//houdehold oil

#include "household_oil/household_oil_materials.inc"

#macro make_box_torus (_rad1,_rad2,_width,_depth)
        #local _pX = (_width/2)-_rad1;
        #local _pZ = (_depth/2)-_rad1; 
        
        #local _corner = 
        difference {
            torus { _rad1, _rad2 }
            plane { <0,0,-1>, 0 } 
            plane { <-1,0,0>, 0 }
        }
       union {  
           object { _corner rotate <0,0,0>      translate <-_pX,0,-_pZ> }  
           object { _corner rotate <0,0,180>    translate <_pX,0,-_pZ>  }
           object { _corner rotate <180,0,0>    translate  <-_pX,0,_pZ> }  
           object { _corner rotate <180,0,180>  translate <_pX,0,_pZ>   }
           object { cylinder {<-_pX,0,0>,<_pX,0,0>,_rad2} translate <0,0,-_depth/2> }
           object { cylinder {<-_pX,0,0>,<_pX,0,0>,_rad2} translate <0,0,_depth/2> }
           object { cylinder {<0,0,-_pZ>,<0,0,_pZ>,_rad2} translate <-_width/2,0,0> }
           object { cylinder {<0,0,-_pZ>,<0,0,_pZ>,_rad2} translate <_width/2,0,0> }
       }
#end




#macro make_box_fillet (_rad1,_height,_width,_depth)
        #local _pX = (_width/2)-_rad1;
        #local _pZ = (_depth/2)-_rad1; 
        
        #local _corner = cylinder {<0,0,0>,<0,_height,0>,_rad1 }
        union {  
            object { _corner  translate < -_pX, 0, -_pZ> }  
            object { _corner  translate < _pX,  0, -_pZ> }
            object { _corner  translate < -_pX, 0, _pZ>  }  
            object { _corner  translate < _pX,  0, _pZ>  }
            box {<-_pX,0,-_depth/2>,<_pX,_height,_depth/2>}
            box {<-_width/2,0,-_pZ>,<_width/2,_height,_pZ>}
        }
#end



#declare _width = 20; 
#declare _depth = 8;  
#declare _height = 40;
#declare _rad1 = 3;
#declare _rad2 = .3 ;

#declare body_A =
union {
    union {
        object { make_box_torus  (_rad1,_rad2,_width,_depth) scale <1,2,1> translate <0,_rad2,0>}
        object { make_box_torus  (_rad1,_rad2,_width,_depth) scale <1,2,1> translate <0,_height,0>}
        material {M_metal_steel_old}
    }
    union {
        object { make_box_fillet (_rad1,_height,_width,_depth) scale <1,1,1> translate <0,0,0> material {M_household_oil_label}}  
        object { make_box_fillet (_rad1,.1,_width,_depth) scale <1,1,1> translate <0,_height,0> material {M_metal_steel_old}}
    }
}  


#declare body_B =
union {
    union {
        object { make_box_torus  (_rad1,_rad2,_width,_depth) scale <1,2,1> translate <0,_rad2,0>}
        object { make_box_torus  (_rad1,_rad2,_width,_depth) scale <1,2,1> translate <0,_height,0>}
        material {M_metal_steel_old}
    }
    union {
        object { make_box_fillet (_rad1,_height,_width,_depth) scale <1,1,1> translate <0,0,0> material {M_household_oil_label_B}}  
        object { make_box_fillet (_rad1,.1,_width,_depth) scale <1,1,1> translate <0,_height,0> material {M_metal_steel_old}}
    }
}  


#declare spout = 
union {
    #declare p1 = <0.000, 40.000, 0.000>  ;
    #declare p2 = <0.000, 45, 0.000>  ; 
    #declare p3 = <0.000, 46, 0.000>  ;
    #declare p4 = <0.000, 50, 0.000>  ;  
    cone {p1,1.4,p2,1.25 material {M_putty_gloss}} 
    cone {p2,1.5,p3,1.6 material {M_red_gloss}} 
    cone {p3,.7,p4,.4 material {M_red_gloss}}
}


#declare household_oil = 
union {
    object {body_A} 
    object {spout}
}


#declare household_oil_B = 
union {
    object {body_B} 
    object {spout}
}


